const { Schema, model } = require("mongoose");

const commentSchema = new Schema(
  {
    content: {
      type: String,
      required: true,
      trim: true,
      maxlength: 1000,
    },
    originalContent: {
      type: String,
      default: null, // stores previous content if soft-deleted
    },
    author: {
      type: Schema.Types.ObjectId,
      ref: "user",
      required: true,
    },
    blog: {
      type: Schema.Types.ObjectId,
      ref: "blog",
      required: true,
    },
    parentComment: {
      type: Schema.Types.ObjectId,
      ref: "comment",
      default: null,
    },
    likes: [
      {
        type: Schema.Types.ObjectId,
        ref: "user",
      },
    ],
    isEdited: { type: Boolean, default: false },
    editedAt: { type: Date, default: null },
    isDeleted: { type: Boolean, default: false },
    deletedAt: { type: Date, default: null },
    isFlagged: { type: Boolean, default: false },
    flaggedBy: [{ type: Schema.Types.ObjectId, ref: "user" }],
  },
  { timestamps: true }
);

// Index for better query performance
commentSchema.index({ blog: 1, createdAt: -1 });
commentSchema.index({ author: 1 });
commentSchema.index({ parentComment: 1 });

const Comment = model("comment", commentSchema);
module.exports = Comment;
