// models/Story.js
const { Schema, model } = require("mongoose");

const storySchema = new Schema(
  {
    title: {
      type: String,
      required: true,
      trim: true,
      maxlength: 250,
    },
    slug: {
      type: String,
      required: true,
      unique: true,
      trim: true,
      lowercase: true,
    },
    excerpt: {
      type: String,
      trim: true,
      maxlength: 500,
    },
    content: {
      type: String,
      required: true,
    }, // HTML or markdown
    author: {
      type: Schema.Types.ObjectId,
      ref: "user",
      required: true,
    },
    genres: [
      {
        type: Schema.Types.ObjectId,
        ref: "genre",
      },
    ],
    coverImage: {
      type: String,
      default: null,
    },
    tags: [
      {
        type: String,
        trim: true,
        index: true,
      },
    ],
    views: {
      type: Number,
      default: 0,
    },
    ratingsCount: {
      type: Number,
      default: 0,
    },
    ratingsAvg: {
      type: Number,
      default: 0,
    }, // precomputed
    likesCount: {
      type: Number,
      default: 0,
    },
    dislikesCount: {
      type: Number,
      default: 0,
    },
    status: {
      type: String,
      enum: ["draft", "published", "archived"],
      default: "draft",
    },
    isDeleted: {
      type: Boolean,
      default: false,
    },
    moderation: {
      flagged: {
        type: Boolean,
        default: false,
      },
      flagCount: {
        type: Number,
        default: 0,
      },
      lastFlaggedAt: {
        type: Date,
      },
    },
  },
  { timestamps: true }
);

storySchema.index({ author: 1, createdAt: -1 });
storySchema.index({ genres: 1, createdAt: -1 });
storySchema.index({ isFeatured: 1, status: 1 });

module.exports = model("story", storySchema);
